/***************************************************************************
 *   Copyright (C) 2006 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __decoder_mpc_h
#define __decoder_mpc_h

#include <mpcdec/mpcdec.h>

#include "decoder.h"

struct mpc_data
{
    mpc_decoder decoder;
    mpc_reader reader;
    mpc_streaminfo info;
};

class DecoderMPC : public Decoder
{
public:
    DecoderMPC(QObject *, DecoderFactory *, QIODevice *, Output *);
    virtual ~DecoderMPC();

    // Standard Decoder API
    bool initialize();
    double lengthInSeconds();
    void seek(double);
    void stop();

    // Equalizer
    bool isEQSupported() const { return FALSE; }
    void setEQEnabled(bool) { ; }
    void setEQGain(int) { ; }
    void setEQBands(int[10]) { ; }

    struct mpc_data *data() { return m_data; }


private:
    // thread run function
    void run();
    struct mpc_data *m_data;
    // helper functions
    void flush(bool = FALSE);
    void deinit();

    bool inited, user_stop;
    int stat;

    // output buffer
    char *output_buf;
    ulong output_bytes, output_at;

    unsigned int bks;
    bool done, finish;
    long len, freq, bitrate;
    int chan;
    unsigned long output_size;
    double totalTime, seekTime;
};


#endif // __decoder_mpc_h
