/***************************************************************************
 *   Copyright (C) 2006 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DOCK_H
#define DOCK_H

#include <QObject>
#include <QPoint>
#include <QWidget>

/**
	@author Ilya Kotov <forkotov02@hotmail.ru>
*/

class QAction;

class Dock : public QObject
{
    Q_OBJECT
public:
    Dock(QObject *parent = 0);

    static Dock *getPointer();
    void setMainWidget(QWidget*);
    void addWidget(QWidget *);
    void move(QWidget*, QPoint);
    void calculateDistances();
    void updateDock();
    QPoint snap(QPoint, QWidget*, QWidget*);
    void addActions(QList<QAction *> actions);
    

    ~Dock();

private:
    bool isDocked(QWidget*, QWidget*);
    static Dock *pointer;
    QWidget *m_mainWidget;
    QList <QWidget *> m_widgetList;
    QList <bool> m_dockedList;
    QList <int> x_list;
    QList <int> y_list;
    QList <QAction *> m_actions;


};

#endif
