/***************************************************************************
 *   Copyright (C) 2006 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _PLAYSTATE_H
#define _PLAYSTATE_H

/**
   @author Vladimir Kuznetsov <vovanec@gmail.com>
 */

#include <playlistmodel.h>

/*!
 * Abstract class that represents data model playing states
 */
class PlayState
{
public:
    /*! Makes single step forward through songs list.
     *  If the step has done returns \b true, otherwise \b false
     */
    virtual bool next() = 0;

    /*! Makes single step back through songs list.
     *  If the step has done returns \b true, otherwise \b false
     */
    virtual bool previous() = 0;

    /*!
     * Service method, resets state to it's defaults.
     */
    virtual void resetState()
    {
        ;
    };

    /*!
     * Service method, can be used for state initializing.
     */
    virtual void prepare()
    {
        ;
    }
    virtual ~PlayState()
    {
        ;
    }
    PlayState(PlayListModel* model) : m_model(model)
    {
        ;
    }
protected:

    /// Data model
    PlayListModel* m_model;
};

/*!
 *  Represents normal playing state.
 *  @author Vladimir Kuznetsov <vovanec@gmail.com>
 */
class NormalPlayState : public PlayState
{
public:
    virtual bool next();
    virtual bool previous();
    NormalPlayState(PlayListModel* model);
};

/*!
 *  Represents shuffle playing state.
 *  @author Vladimir Kuznetsov <vovanec@gmail.com>
 */
class ShufflePlayState : public PlayState
{
public:
    virtual bool next();
    virtual bool previous();
    virtual void prepare();
    ShufflePlayState(PlayListModel* model);
    virtual void resetState();
private:

    /// Current shuffled index.
    int m_shuffled_current;

    /// List of indexes used for shuffled playing.
    QList<int> m_shuffled_indexes;
};


#endif
