/***************************************************************************
 *   Copyright (C) 2013-2024 by Ilya Kotov                                 *
 *   forkotov02@ya.ru                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include <QMessageBox>
#include "trackchange.h"
#include "trackchangesettingsdialog.h"
#include "trackchangefactory.h"

GeneralProperties TrackChangeFactory::properties() const
{
    GeneralProperties properties;
    properties.name = tr("Track Change Plugin");
    properties.shortName = "trackchange"_L1;
    properties.hasAbout = true;
    properties.hasSettings = true;
    properties.visibilityControl = false;
    return properties;
}

QObject *TrackChangeFactory::create(QObject *parent)
{
    return new TrackChange(parent);
}

QDialog *TrackChangeFactory::createSettings(QWidget *parent)
{
    return new TrackChangeSettingsDialog(parent);
}

void TrackChangeFactory::showAbout(QWidget *parent)
{
    QMessageBox::about(parent, tr("About Track Change Plugin"),
                       tr("Qmmp Track Change Plugin") + QChar::LineFeed +
                       tr("This plugin executes external command when current track is changed") + QChar::LineFeed +
                       tr("Written by: Ilya Kotov <forkotov02@ya.ru>"));
}

QString TrackChangeFactory::translation() const
{
    return QLatin1String(":/trackchange_plugin_");
}
